<?php
/* --------------------------------------------------------------
   TemplateTranslations.php 2020-04-16
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\Layout\Smarty;

use Gambio\Core\Application\ValueObjects\UserPreferences;
use Gambio\Core\Language\TextManager;
use JsonSerializable;

/**
 * Class TemplateTranslations
 *
 * @package Gambio\Admin\Layout\Smarty
 */
class TemplateTranslations implements JsonSerializable
{
    /**
     * @var TextManager
     */
    private $textManager;
    
    /**
     * @var int
     */
    private $languageId;
    
    /**
     * @var array string[]
     */
    private $translations = [];
    
    
    /**
     * TemplateTranslations constructor.
     *
     * @param TextManager     $textManager
     * @param UserPreferences $userPreferences
     */
    public function __construct(TextManager $textManager, UserPreferences $userPreferences)
    {
        $this->textManager = $textManager;
        $this->languageId  = $userPreferences->languageId();
    }
    
    
    /**
     * @param string $section
     *
     * @return $this
     */
    public function addSection(string $section): void
    {
        $this->translations[$section] = $this->textManager->getSectionPhrases($section, $this->languageId);
    }
    
    
    /**
     * @inheritDoc
     */
    public function jsonSerialize(): array
    {
        return $this->translations;
    }
}